;     
;   8 

.cseg
.include "tn2313def.inc"
;.device		ATtiny2313;

.org		$000
			rjmp Main_Program	;   
.org		$007
			rjmp USART_RXC


;---------------------------
;
;---------------------------
.def	Count	=	r1		; 
.def	Count1	=	r2

.def	Count2	=	r3		;
.def	Count3	=	r4		;   Temp

.def	Count4	=	r5		;	ldi	Temp,N
.def	Count5	=	r6		;	mov	CountX,Temp

.def	Count6	=	r7		;
.def	Count7	=	r8		;

.def	Count8	=	r9		;    EEPROM
.def	Count9	=	r10		;    EEPROM

.def	Flag	=	r15		; 

.def	Temp	=	r16		;Temp
.def	Data	=	r17
.def	CFG		=	r18		; 
.def	PWM3	=	r19


;---------------------------
;
;---------------------------
//Flag
.equ	LST		=	0
.equ	LST3	=	1
.equ	LMode	=	2
.equ	P_Key	=	3
.equ	P_Key3	=	4
.equ	P_SKey	=	5
.equ	K3WOn	=	6

//cfg
.equ	L1		=	0
.equ	L2		=	1
.equ	L3		=	2


;---------------------------
;
;---------------------------
.equ	KeyL	=	pina	;
.equ	Up		=	1		;KeyL,red
.equ	Down	=	0		;KeyL,black

.equ	Key		=	pind	;
.equ	LA		=	2		;
.equ	LB		=	3		;

.equ	SL		=	portd	;
.equ	Power	=	5		;
.equ	Mode	=	4		;



;---------------------------
;
;---------------------------
.equ	C3		=	5		;  +/-
.equ	C4		=	10		;  +/- 3W

.equ	C5		=	230		;    
.equ	C6		=	2		;

.equ	C5_2	=	255		;    
.equ	C6_2	=	10		;

.equ	C7		=	20		;  

.equ	C8		=	150		;  

;---------------------------------------------------------------------------
; 
;---------------------------------------------------------------------------
USART_RXC:	cli
			push	Temp
			push	Data
			in		Temp,SREG
			push	Temp

			sbi		SL,mode		; 

			// UART    
			// 

/*								;  
0x50 = P - 
0x52 = R -  cfg
0x57 = W -  cfg
0x4C = L -   3W
0x33 = 3 -    3W
0x6C = l -   3W
0x53 = S -  
*/

			in		Data,UDR

			set
			bld		Flag,LMode

Ping:		cpi		Data,0x50
			brne	Read_CFG
			ldi		Temp,0x70
			out		UDR,Temp			; - "p"
			rcall	TX
			rjmp	End_UART


Read_CFG:	cpi		Data,0x52
			brne	Write_CFG
			out		UDR,cfg
			rcall	TX
			rjmp	End_UART

Write_CFG:	cpi		Data,0x57
			brne	Read_PWM
			rcall	RX
			in		cfg,UDR
			rjmp	End_UART

Read_PWM:	cpi		Data,0x4C
			brne	Read_PWM3
			in		Temp,OCR0A
			out		UDR,Temp
			rcall	TX
			rjmp	End_UART

Read_PWM3:	cpi		Data,0x33
			brne	Write_PWM
			out		UDR,PWM3
			rcall	TX
			rjmp	End_UART

Write_PWM:	cpi		Data,0x6C
			brne	Sawe_PWM
			rcall	RX
			in		PWM3,UDR
			out		OCR0A,PWM3
			rjmp	End_UART

Sawe_PWM:	cpi		Data,0x53
			brne	End_UART
			mov		Data,PWM3			;    
			ldi		Temp,$01
			rcall	Write_EEPROM

End_UART:	cbi		SL,mode
			pop		Temp
			out		SREG,Temp
			pop		Data
			pop		Temp
			sei
			reti



;---------------------------------------------------------------------------
;   UART
;---------------------------------------------------------------------------
TX:			sbis	UCSRA,TXC			; 
			rjmp	TX
			ret

RX:			sbis	UCSRA,RXC			; 
			rjmp	RX
			ret



;---------------------------------------------------------------------------
; 
;---------------------------------------------------------------------------
Main_Program:
			cli							; 
			ldi 	Temp,RAMEND			;  
			out 	spl,Temp			;  SRAM 0xFD

			ldi		Temp,0x55
			out		OSCCAL,Temp			;    8MHz 0x55

			sbi		ACSR,ACD			; 

			rcall	Ports_cfg			;  
			rcall	PWM_cfg				; 
			rcall	UART_cfg			; UART

			rcall	Delay_1ms
			rcall	Delay_1ms
			rcall	Delay_1ms
			rcall	Delay_1ms

			clr		Flag
			clr		cfg
			clr		PWM3
			clr		Count3
			clr		Count4
			clr		Count5
			clr		Count6
			clr		Count7
			clr		Count8

			ldi		Temp,0x01			;    
			rcall	Read_EEPROM
			mov		PWM3,Data

			sei



////////////


Start:		rcall	Read_KEY

LSET:		cbi		SL,Power			;  
			sbrc	Flag,P_SKey
			sbi		SL,Power


LM:			sbrs	Flag,LMode			;   
			rjmp	LMOff
			sbi		SL,Mode

			mov		Temp,Count8
			cpi		Temp,0x00
			brne	l_mt
			ldi		Temp,C8
			mov		Count8,Temp	

l_mt:		dec		Count8
			brne	FLST

LMOff:		cbi		SL,Mode
			clt
			bld		Flag,LMode



FLST:		sbrs	Flag,LST			;    
			rjmp	FL1

FLT:		mov		Temp,Count3
			cpi		Temp,0x00
			brne	l_t
			ldi		Temp,C3
			mov		Count3,Temp	

l_t:		dec		Count3
			brne	FLST3


///////
FL1:		sbrs	cfg,L1				;  
			rjmp	L1Off
L1On:		in		Temp,OCR1AL
			cpi		Temp,0xFF
			breq	FL2

			set
			bld		Flag,LST

			rcall	On_L1

			inc		Temp
			out		OCR1AL,Temp
			cpi		Temp,0xFF
			brne	FL2

			clt
			bld		Flag,LST

			rjmp	FL2

L1Off:		in		Temp,OCR1AL
			cpi		Temp,0x00
			breq	FL2

			set
			bld		Flag,LST

			dec		Temp
			out		OCR1AL,Temp
			cpi		Temp,0x00
			brne	FL2

			rcall	Off_L1
			clt
			bld		Flag,LST


FL2:		sbrs	cfg,L2
			rjmp	L2Off
L2On:		in		Temp,OCR1BL
			cpi		Temp,0xFF
			breq	FLST3

			set
			bld		Flag,LST

			rcall	On_L2

			inc		Temp
			out		OCR1BL,Temp
			cpi		Temp,0xFF
			brne	FLST3

			clt
			bld		Flag,LST

			rjmp	FLST3

L2Off:		in		Temp,OCR1BL
			cpi		Temp,0x00
			breq	FLST3

			set
			bld		Flag,LST

			dec		Temp
			out		OCR1BL,Temp
			cpi		Temp,0x00
			brne	FLST3

			rcall	Off_L2
			clt
			bld		Flag,LST

			rjmp	FLST3


/////////////////
FLR:		rjmp	FL			
/////////////////

FLST3:		sbrs	Flag,LST3			;    
			rjmp	FL3

FLT3:		mov		Temp,Count4
			cpi		Temp,0x00
			brne	l_t3
			ldi		Temp,C4
			mov		Count4,Temp	

l_t3:		dec		Count4
			brne	FL



FL3:		sbrs	cfg,L3
			rjmp	L3Off
L3On:		in		Temp,OCR0A
			cp		Temp,PWM3
			breq	FL

			sbrc	Flag,LST3
			rjmp	L3OnU
			set
			bld		Flag,LST3
			
			push	Temp				; 
			in		Temp,TCCR0A
			sbr		Temp,(1<<COM0A1)
			out		TCCR0A,Temp
			pop		Temp

L3OnU:		inc		Temp
			out		OCR0A,Temp
			cpi		Temp,0xFA
			brne	FL

			clt
			bld		Flag,LST3

			rjmp	FL

L3Off:		in		Temp,OCR0A
			cpi		Temp,0x00
			breq	FL

			set
			bld		Flag,LST3

			dec		Temp
			out		OCR0A,Temp
			cpi		Temp,0x00
			brne	FL

			clt
			bld		Flag,LST3

			in		Temp,TCCR0A			; 
			cbr		Temp,(1<<COM0A1)
			out		TCCR0A,Temp

FL:			rcall	Delay_1ms

			rjmp	Start




;-----------------------------------------------------------------------------
; :
;-----------------------------------------------------------------------------

;    
Ports_cfg:	ldi	Temp,0b00000000		;  PA
			out	ddra,Temp			; 

			ldi	Temp,0b11111111		;  PB
			out	ddrb,Temp			; 

			ldi	Temp,0b01110010		;  PD
			out	ddrd,Temp			;PD0,2,3 - 

			sbi	porta,0				; PULLUP's PA0,1, PD2,3
			sbi	porta,1
			sbi	portd,2
			sbi	portd,3

			cbi portb,2				;  
			cbi portb,3
			cbi portb,4

			ret


PWM_cfg:	clr	Temp				;   T0 (3W)
		;	sbr	Temp,(1<<COM0A1)
			sbr	Temp,(1<<WGM01)
			sbr	Temp,(1<<WGM00)
			out	TCCR0A,Temp

			ldi	Temp,0
			out	OCR0A,Temp
			ldi	Temp,250
			out	TCNT0,Temp

			clr	Temp
			sbr	Temp,(1<<CS01)
			sbr	Temp,(1<<CS00)
			out	TCCR0B,Temp			;WGM02


			clr	Temp				;   T1
			sbr	Temp,(1<<WGM10)
			out	TCCR1A,Temp

			ldi	Temp,0
			out	OCR1AL,Temp
			ldi	Temp,0
			out	OCR1BL,Temp
			ldi	Temp,0
			out	TCNT1H,Temp
			ldi	Temp,250
			out	TCNT1L,Temp

			clr	Temp
			sbr	Temp,(1<<WGM12)
			sbr	Temp,(1<<CS11)
			sbr	Temp,(1<<CS10)
			out	TCCR1B,Temp

			ret


UART_cfg:	clr	Temp				;   UART
			sbr	Temp,(1<<RXCIE)
			sbr	Temp,(1<<RXEN)
			sbr	Temp,(1<<TXEN)
			out	UCSRB,Temp

			clr	Temp				; 
		;	sbr	Temp,(1<<UMSEL)
			sbr	Temp,(1<<UCSZ1)
			sbr	Temp,(1<<UCSZ0)
			sbr	Temp,(1<<UCPOL)
			out	UCSRC,Temp

			ldi	Temp,12				;  UART 38400 (19200-25)
			out	UBRRL,Temp

			ret

////////////

On_L1:		push	Temp				;   
			in		Temp,TCCR1A
			sbr		Temp,(1<<COM1A1)
		;	sbr		Temp,(1<<COM1A0)
			out		TCCR1A,Temp
		;	cbi 	portb,3
			ldi		Temp,255
			out		TCNT1L,Temp
			pop		Temp
			ret

On_L2:		push	Temp				;   B
			in		Temp,TCCR1A
			sbr		Temp,(1<<COM1B1)
		;	sbr		Temp,(1<<COM1B0)
			out		TCCR1A,Temp
		;	cbi 	portb,4
			ldi		Temp,255
			out		TCNT1L,Temp
			pop		Temp
			ret


Off_L1:		push	Temp				;   
			cbi 	portb,3
			in		Temp,TCCR1A
			cbr		Temp,(1<<COM1A1)
		;	cbr		Temp,(1<<COM1A0)
			out		TCCR1A,Temp
			pop		Temp
			ret

Off_L2:		push	Temp				;   B
			cbi 	portb,4
			in		Temp,TCCR1A
			cbr		Temp,(1<<COM1B1)
		;	cbr		Temp,(1<<COM1B0)
			out		TCCR1A,Temp
			pop		Temp
			ret



;   ,    
;   EEPROM
;:  Term, Data_t, Data
;: Termo,On
Read_Key:
Key_A:		sbic	Key,LA
			rjmp	Key_B
			sbrc	Flag,P_Key
			rjmp	Key3W

			set
			bld		Flag,LMode

			set
			sbrc	cfg,L1
			clt
			bld		cfg,L1
			set
			bld		Flag,P_Key

			rjmp	Key3W

Key_B:		sbic	Key,LB
			rjmp	NPK
			sbrc	Flag,P_Key
			rjmp	Key3W

			set
			bld		Flag,LMode

			set
			sbrc	cfg,L2			
			clt
			bld		cfg,L2
			set
			bld		Flag,P_Key

			rjmp	Key3W

NPK:		clt
			bld		Flag,P_Key

////////////////////////////////////////


Key3W:		sbrc	Flag,P_SKey
			rjmp	Key3WS

Key3WOn:	sbis	KeyL,Up
			rjmp	K3WOnF

			sbrs	Flag,K3WOn
			rjmp	Key3WOff

			clt
			bld		Flag,P_Key3
			bld		Flag,K3WOn
			rjmp	ExitCK

K3WOnF:		set
			bld		Flag,LMode
			bld		Flag,K3WOn

			sbrc	Flag,P_Key3
			rjmp	ExitCK

			clt
			sbrc	cfg,L3
			set
			bld		Flag,P_SKey

			set							; 
			bld		cfg,L3

			set
			bld		Flag,P_Key3

			rjmp	ExitCK




Key3WOff:	sbrs	cfg,L3
			rjmp	CK
			sbic	KeyL,Down
			rjmp	K3WUp
			set
			bld		Flag,LMode

			sbrc	Flag,P_Key3
			rjmp	TSCK

			set
			bld		Flag,P_Key3
			ldi		Temp,C5				;  
			mov		Count5,Temp
			ldi		Temp,C6
			mov		Count6,Temp
			rjmp	TSCK

K3WUp:		sbrs	Flag,P_Key3
			rjmp	CK



TSCK:		dec		Count5				;   
			brne	Exit_UP

			mov		Temp,Count6
			cpi		Temp,0x00

			brne	l_ck3
			ldi		Temp,C6_2
			mov		Count6,Temp	
l_ck3:		dec		Count6
			brne	Exit_UP

			sbis	KeyL,Down			;    
			rjmp	InSet

			clt							;
			bld		cfg,L3

			rjmp	CK

InSet:		set							;    
			bld		Flag,P_SKey
			clr		Count5				;   
			clr		Count6

			rjmp	CK


////////////////////////////////////////

Key3WS:									; 
Key3Up:		sbic	KeyL,Up				;  "+"
			rjmp	Key3Down

			set
			bld		Flag,LMode			;

			clr		Count5				;   
			clr		Count6

T_UP:		mov		Temp,Count7			;
			cpi		Temp,0x00
			brne	lt_up
			ldi		Temp,C7
			mov		Count7,Temp	
lt_up:		dec		Count7
			brne	Exit_UP

			in		PWM3,OCR0A			;
			cpi		PWM3,250
			breq	Exit_UP
			inc		PWM3
			out		OCR0A,PWM3

Exit_UP:	in		Temp,OCR0A			; 
			cpi		Temp,250
			brne	Exit_UPW
			clt
			bld		Flag,LMode			;

Exit_UPW:	rjmp	ExitCK

////////////////////////////////////////

Key3Down:	sbic	KeyL,Down			;  "-"
			rjmp	ExitKey

			set
			bld		Flag,LMode			;

			clr		Count5				;   
			clr		Count6

T_DW:		mov		Temp,Count7			;
			cpi		Temp,0x00
			brne	lt_dw
			ldi		Temp,C7
			mov		Count7,Temp	
lt_dw:		dec		Count7
			brne	Exit_DP

			in		PWM3,OCR0A			;
			cpi		PWM3,0
			breq	Exit_DP
			dec		PWM3
			out		OCR0A,PWM3

Exit_DP:	in		Temp,OCR0A			; 
			cpi		Temp,0
			brne	Exit_DPW
			clt
			bld		Flag,LMode			;

Exit_DPW:	rjmp	ExitCK

////////////////////////////////////////


ExitKey:	sbrs	Flag,P_SKey			;    
			rjmp	ExitCK

			mov		Temp,Count5			;   
			cpi		Temp,0x00
			brne	l_ck

			ldi		Temp,C5_2
			mov		Count5,Temp	
l_ck:		dec		Count5
			brne	CK

			mov		Temp,Count6
			cpi		Temp,0x00

			brne	l_ck2
			ldi		Temp,C6_2
			mov		Count6,Temp	
l_ck2:		dec		Count6
			brne	CK

			clt
			bld		Flag,P_SKey

			mov		Data,PWM3			;     
			ldi		Temp,$01
			rcall	Write_EEPROM


CK:			clt
			bld		Flag,P_Key3

ExitCK:
			ret




;   Data  EEPROM
;:  Data, Temp
;: EEPROM
Write_EEPROM:
			out		EEAR,Temp		;    EEPROM
			out		EEDR,Data		;  
			sbi		EECR,EEMWE
			sbi		EECR,EEWE
wr:			sbic	EECR,EEWE
			rjmp	wr
			ret


;    EEPROM
;:  Temp, EEPROM
;: Data
Read_EEPROM:
			out		EEAR,Temp		;    EEPROM
			sbi		EECR,EERE
rr:			sbic	EECR,EERE
			rjmp	rr
			in		Data,EEDR		;   EEPROM  DATA
			ret




;   -  0,5 
Delay_005ms:
			ldi		Temp,96
			mov		Count1,Temp       
l_2:		nop
			dec		Count1
			brne	l_2

			ret



;   -  0,05 
Delay_10mks:
			ldi		Temp,40
			mov		Count1,Temp
l_1:		nop
			dec		Count1
			brne	l_1

			ret



;   -  1 
Delay_1ms:
			ldi		Temp,255
			mov		Count1,Temp
			ldi		Temp,8				;8
			mov		Count2,Temp
l_0:		nop
			dec		Count1
			brne	l_0
			dec		Count2
			brne	l_0
			ret



;***************************************************************************
; EEPROM:
.eseg

EEData:			.db	$55						;0x00   
				.db	$30						;0x01  c  
